IF  EXISTS (SELECT 1 FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[UFD_PIS_COFINS_POR_CST]') AND TYPE IN (N'FN', N'IF', N'TF', N'FS', N'FT'))
    DROP FUNCTION [UFD_PIS_COFINS_POR_CST]
GO 



CREATE FUNCTION [dbo].[UFD_PIS_COFINS_POR_CST] (@CD_EMP INT, 
												@CD_FILIAL INT, 
												@CD_NT_MOV INT,
												@CD_NT_OP INT,
												@CD_DOC INT,
												@CD_PROD INT,
												@VLR_PROD_BASE_IMPOSTO MONEY,
												@CD_CST AS INT)
RETURNS @UFD_RETURN TABLE
(VLR_BASE_IMPOSTO                 MONEY,
 PERC_PIS                         MONEY,
 VLR_PIS                          MONEY,
 PERC_COFINS                      MONEY,
 VLR_COFINS                       MONEY,
 CST_TP_TRIB_PIS				  INT
)

	BEGIN
		
		DECLARE @VLR_BASE_IMPOSTO MONEY = 0;
		DECLARE @PERC_PIS MONEY;
		DECLARE @VLR_PIS MONEY;
		DECLARE @PERC_COFINS MONEY;
		DECLARE @VLR_COFINS MONEY;

		DECLARE @FLAG_NAO_TRIBUTAR_PIS_COFINS INT;
		DECLARE @TP_TRANSA INT;
		DECLARE @TP_TRIB_CST_PISCOFINS INT;
		DECLARE @TP_REGIME_APURACAO_PISCOFINS INT;
		DECLARE @TP_REGIME_APURACAO_ICMS INT;
		DECLARE @DEDUZIR_ICMS_ST_BASE_PISCOFINS INT;
		DECLARE @DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS INT;
		DECLARE @DATADEDUZIR_ENTRADA DATE;
		DECLARE @DATADEDUZIR_SAIDA DATE;

		SELECT @TP_REGIME_APURACAO_PISCOFINS = ISNULL(TP_REGIME_APURAC_PIS_COFINS, 0) , 
			   @TP_REGIME_APURACAO_ICMS = ISNULL(REGIME_TRIBUTARIO, 0),
			   @DEDUZIR_ICMS_ST_BASE_PISCOFINS = ISNULL(DEDUZIR_ICMS_ST_BASE_PISCOFINS,0),
			   @DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS = ISNULL(DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS,0)
		FROM PRC_FILIAL
		WHERE CD_FILIAL = @CD_FILIAL;
 
		SELECT @FLAG_NAO_TRIBUTAR_PIS_COFINS = ISNULL(FLAG_NAO_TRIBUTAR_PIS_COFINS, 0),
			   @TP_TRANSA = TP_MOV_OP_TRANSA
		FROM GLB_MOV_OP
		WHERE CD_MOV_OP = @CD_NT_MOV --EST_NF_ENT.CD_NT_MOV

		--Analisando se o CST e tributavel
		SELECT @TP_TRIB_CST_PISCOFINS = TP_TRIB
		FROM CST_PIS_COFINS
		WHERE CD_CST = @CD_CST;

		SET @DATADEDUZIR_SAIDA = ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'DT_INICIO_EXCLUSAO_ICMS_PIS_COFINS', 1, @CD_FILIAL)),0)
		SET @DATADEDUZIR_ENTRADA = CASE ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'DT_INICIO_EXCLUSAO_ICMS_PIS_COFINS_NF_ENTRADA', 1, @CD_FILIAL)) , '2023-05-01')
								   WHEN '' THEN '2023-05-01'
								   ELSE ISNULL((SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'DT_INICIO_EXCLUSAO_ICMS_PIS_COFINS_NF_ENTRADA', 1, @CD_FILIAL)) , '2023-05-01')
								   END
		
		--Se for igual a zero nao possui imposto
		IF @TP_TRIB_CST_PISCOFINS = 0
			BEGIN
				SET @VLR_BASE_IMPOSTO = 0;
				SET @PERC_PIS = 0;
				SET @VLR_PIS = 0;
				SET @PERC_COFINS = 0;
				SET @VLR_COFINS = 0;
			END;
		ELSE
			BEGIN
			/*Deduo*/

				/*Entrada*/
				IF @TP_TRANSA = 0
				BEGIN
					IF @TP_REGIME_APURACAO_PISCOFINS = 0 AND @TP_REGIME_APURACAO_ICMS = 4
					BEGIN
						SET @VLR_BASE_IMPOSTO = @VLR_PROD_BASE_IMPOSTO - (ISNULL((SELECT EST_NF_ENT_IT.VLR_ICMS_IT +

																				  ISNULL((CASE WHEN @DEDUZIR_ICMS_ST_BASE_PISCOFINS = 0 THEN 0
																						  ELSE CASE WHEN EST_NF_ENT_IT.VLR_ICMS_RET > (VLR_TOT_IT) THEN 0
																							   ELSE EST_NF_ENT_IT.VLR_ICMS_RET END  
																						  END),0)

																				  FROM EST_NF_ENT_IT

																				  INNER JOIN EST_NF_ENT ON EST_NF_ENT_IT.CD_EMP = EST_NF_ENT.CD_EMP
																					                   AND EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT.CD_FILIAL
																					                   AND EST_NF_ENT_IT.CD_NF = EST_NF_ENT.CD_NF
																					                   AND EST_NF_ENT_IT.DT_ENT = EST_NF_ENT.DT_ENT 

																				  WHERE EST_NF_ENT_IT.CD_NF = @CD_DOC
																					AND EST_NF_ENT_IT.CD_FILIAL = @CD_FILIAL
																					AND EST_NF_ENT_IT.CD_EMP = @CD_EMP
																					AND CD_PROD = @CD_PROD
																					AND EST_NF_ENT_IT.DT_ENT >= @DATADEDUZIR_ENTRADA 
																					AND EXISTS (SELECT 1
																								  FROM GLB_NT_OP OP
																								  WHERE OP.CD_NT_OP = EST_NF_ENT_IT.CD_NT_OP
																								  AND ISNULL(FLAG_NAO_DEDUZ_ICMS_BASE_PIS_COFINS,0) = 0)),0))
					END
				END

				/*Saida*/
				IF @TP_TRANSA = 1 AND @DEDUZIR_ICMS_NORMAL_BASE_PISCOFINS = 1 
				BEGIN
					SET @VLR_BASE_IMPOSTO = @VLR_PROD_BASE_IMPOSTO - (ISNULL((SELECT EST_NF_SAI_IT.VLR_ICMS_IT

																				FROM EST_NF_SAI_IT

																				INNER JOIN EST_NF_SAI ON EST_NF_SAI_IT.CD_EMP = EST_NF_SAI.CD_EMP
																									AND EST_NF_SAI_IT.CD_FILIAL = EST_NF_SAI.CD_FILIAL
																									AND EST_NF_SAI_IT.CD_NF = EST_NF_SAI.CD_NF
																									AND EST_NF_SAI_IT.DT_EMI_NF = EST_NF_SAI.DT_EMI_NF 

																				WHERE EST_NF_SAI_IT.CD_NF = @CD_DOC
																					AND EST_NF_SAI_IT.CD_FILIAL = @CD_FILIAL
																					AND EST_NF_SAI_IT.CD_EMP = @CD_EMP
																					AND CD_PROD = @CD_PROD
																					AND EST_NF_SAI_IT.DT_EMI_NF >= @DATADEDUZIR_SAIDA  
																					AND EXISTS (SELECT 1
																								FROM GLB_NT_OP OP
																								WHERE OP.CD_NT_OP = EST_NF_SAI_IT.CD_NT_OP
																								AND ISNULL(FLAG_NAO_DEDUZ_ICMS_BASE_PIS_COFINS,0) = 0)),0))
				END;
			END;
			/*Fim deduo*/

		--Natureza tributa pis/cofins
		IF (@FLAG_NAO_TRIBUTAR_PIS_COFINS = 0 AND @TP_TRIB_CST_PISCOFINS = 1)
			BEGIn

			--Buscando Aliquota de PIS
			--1 - PIS - NO CUMULATIVO
			--2 - COFINS - NO CUMULATIVO
			--32 - PIS - CUMULATIVO"
			--33 - COFINS - CUMULATIVO
				
				SELECT TOP 1 @PERC_PIS = PERC_IMP
				FROM GLB_IMPOSTOS
				WHERE TIPO_IMPOSTO = CASE WHEN @TP_REGIME_APURACAO_PISCOFINS = 0 THEN 1
										ELSE 32
										END;
					
				--Buscando Aliquota de COFINS
				SELECT TOP 1 @PERC_COFINS = PERC_IMP
				FROM GLB_IMPOSTOS
				WHERE TIPO_IMPOSTO = CASE WHEN @TP_REGIME_APURACAO_PISCOFINS = 0 THEN 2
										ELSE 33
										END;
				
				--Calculando PIS
				SET @VLR_PIS = ROUND((@VLR_BASE_IMPOSTO * @PERC_PIS) / 100.00, 4);

				--Calculando COFINS
				SET @VLR_COFINS = ROUND((@VLR_BASE_IMPOSTO * @PERC_COFINS) / 100.00, 4);
				
			END; --FIM @FLAG_NAO_TRIBUTAR_PIS_COFINS = 0

		--Se for igual a so tem base
		IF @TP_TRIB_CST_PISCOFINS = 2
			BEGIN
				SET @PERC_PIS = 0;
				SET @VLR_PIS = 0;
				SET @PERC_COFINS = 0;
				SET @VLR_COFINS = 0;
			END;

		IF @VLR_BASE_IMPOSTO < 0 
		BEGIN
			SET @VLR_BASE_IMPOSTO=0
			SET @VLR_PIS=0
			SET @PERC_PIS=0
			SET @VLR_COFINS=0
			SET @PERC_COFINS=0
		END 
		 
		IF @TP_REGIME_APURACAO_ICMS  = 1 AND  @TP_TRANSA = 1  -- Filial optante pelo simples Nacional
			BEGIN
				SET @VLR_BASE_IMPOSTO=0
				SET @VLR_PIS=0
				SET @PERC_PIS=0
				SET @VLR_COFINS=0
				SET @PERC_COFINS=0
			END;
		 
         INSERT INTO @UFD_RETURN
                SELECT @VLR_BASE_IMPOSTO,
                       @PERC_PIS,
                       @VLR_PIS,
                       @PERC_COFINS,
                       @VLR_COFINS,
					   @TP_TRIB_CST_PISCOFINS;
		RETURN;
	END;
GO


